/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class ServoBlock
extends TranslatorBlock {
    public ServoBlock(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        TranslatorBlock translatorBlock = this.getRequiredTranslatorBlockAtSocket(0);
        String pinNumber = translatorBlock.toCode();
        String servoName = "servo_pin_" + pinNumber;
        translatorBlock = this.getRequiredTranslatorBlockAtSocket(1);
        String ret = servoName + ".write( " + translatorBlock.toCode() + " );\n";
        this.translator.addHeaderFile("Servo.h");
        this.translator.addDefinitionCommand("Servo " + servoName + ";");
        this.translator.addSetupCommand(servoName + ".attach(" + pinNumber + ");");
        return ret;
    }
}

