/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block.tinker;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.NumberBlock;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.BlockException;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;
import com.ardublock.translator.block.tinker.TinkerInputPortBlock;

public abstract class AbstractTinkerReadAnalogBlock
extends TranslatorBlock {
    AbstractTinkerReadAnalogBlock(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
        translator.addHeaderFile("TinkerKit.h");
    }

    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        String ret = "analogRead(";
        TranslatorBlock translatorBlock = this.getRequiredTranslatorBlockAtSocket(0);
        if (translatorBlock instanceof NumberBlock) {
            ret = ret + "A";
            ret = ret + translatorBlock.toCode();
            ret = ret + ")";
            return this.codePrefix + ret + this.codeSuffix;
        }
        if (translatorBlock instanceof TinkerInputPortBlock) {
            ret = ret + translatorBlock.toCode();
            ret = ret + ")";
            return this.codePrefix + ret + this.codeSuffix;
        }
        throw new BlockException(this.blockId, "analog pin# must be a number");
    }
}

