/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.DigitalOutputBlock;
import com.ardublock.translator.block.NumberBlock;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class InversedDigitalOutputBlock
extends DigitalOutputBlock {
    public InversedDigitalOutputBlock(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        TranslatorBlock translatorBlock = this.getRequiredTranslatorBlockAtSocket(0);
        if (translatorBlock instanceof NumberBlock) {
            String number = translatorBlock.toCode();
            this.translator.addOutputPin(number.trim());
            String ret = "digitalWrite( ";
            ret = ret + number;
            ret = ret + " , ";
            translatorBlock = this.getRequiredTranslatorBlockAtSocket(1);
            ret = ret + translatorBlock.toCode();
            ret = ret + " );\n";
            return ret;
        }
        this.translator.addDefinitionCommand("void __ardublockDigitalWrite(int pinNumber, boolean status)\n{\npinMode(pinNumber, OUTPUT);\ndigitalWrite(pinNumber, status);\n}\n");
        String ret = "__ardublockDigitalWrite(";
        ret = ret + translatorBlock.toCode();
        ret = ret + ", !(";
        translatorBlock = this.getRequiredTranslatorBlockAtSocket(1);
        ret = ret + translatorBlock.toCode();
        ret = ret + "));\n";
        return ret;
    }
}

