/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class LCD_I2C_Sainsmart_16by2_Block
extends TranslatorBlock {
    public LCD_I2C_Sainsmart_16by2_Block(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        TranslatorBlock tb = this.getRequiredTranslatorBlockAtSocket(1);
        String lineNo = tb.toCode();
        tb = this.getRequiredTranslatorBlockAtSocket(2);
        String charNo = tb.toCode();
        tb = this.getRequiredTranslatorBlockAtSocket(3);
        String I2C_addr = tb.toCode();
        String ret = "";
        if (!charNo.equals("0") || !lineNo.equals("0")) {
            ret = "lcd_I2C_" + I2C_addr + ".setCursor( (" + charNo + ") - 1, (" + lineNo + ") - 1 );";
        }
        tb = this.getRequiredTranslatorBlockAtSocket(0, "lcd_I2C_" + I2C_addr + ".print( ", " );\n");
        ret = ret + tb.toCode();
        this.translator.addHeaderFile("Wire.h");
        this.translator.addHeaderFile("LCD.h");
        this.translator.addHeaderFile("LiquidCrystal_I2C.h");
        this.translator.addDefinitionCommand("// For these LCD controls to work you MUST replace the standard LCD library with 'New LCD' from...");
        this.translator.addDefinitionCommand("// https://bitbucket.org/fmalpartida/new-liquidcrystal/wiki/Home");
        this.translator.addDefinitionCommand("// Direct download https://bitbucket.org/fmalpartida/new-liquidcrystal/downloads/LiquidCrystal_V1.2.1.zip");
        this.translator.addDefinitionCommand("// Your project will not compile until this is done.");
        this.translator.addDefinitionCommand("//");
        this.translator.addDefinitionCommand("LiquidCrystal_I2C lcd_I2C_" + I2C_addr + "(0x" + I2C_addr + ", 2, 1, 0, 4, 5, 6, 7, 3, POSITIVE);");
        this.translator.addSetupCommand("lcd_I2C_" + I2C_addr + ".begin (16, 2);");
        this.translator.addSetupCommand("lcd_I2C_" + I2C_addr + ".setBacklight(HIGH);");
        return ret;
    }
}

