/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block.dfrobot;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class Dht11HumidityBlock
extends TranslatorBlock {
    public Dht11HumidityBlock(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        TranslatorBlock translatorBlock = this.getRequiredTranslatorBlockAtSocket(0);
        String pinNumber = translatorBlock.toCode();
        String dht11Name = "dht11_pin_" + pinNumber;
        this.translator.addHeaderFile("HqcDht11.h");
        this.translator.addDefinitionCommand("Dht11 " + dht11Name + "(" + pinNumber + ");\n");
        this.translator.addSetupCommand(dht11Name + ".init();\n");
        String ret = dht11Name + ".getHumidity()";
        return this.codePrefix + ret + this.codeSuffix;
    }
}

