/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblocks;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.codeblocks.BlockConnector;
import edu.mit.blocks.codeblocks.BlockLink;
import edu.mit.blocks.codeblocks.BlockLinkChecker;
import edu.mit.blocks.codeblocks.LinkRule;
import edu.mit.blocks.workspace.Workspace;
import edu.mit.blocks.workspace.WorkspaceEvent;
import edu.mit.blocks.workspace.WorkspaceListener;
import java.util.HashMap;

public class StackRule
implements LinkRule,
WorkspaceListener {
    private final Workspace workspace;
    private static HashMap<Long, Long> topBlock;
    private static HashMap<Long, String> stackType;

    public StackRule(Workspace workspace) {
        this.workspace = workspace;
        topBlock = new HashMap();
        stackType = new HashMap();
    }

    @Override
    public boolean canLink(Block block1, Block block2, BlockConnector socket1, BlockConnector socket2) {
        String type1 = stackType.get(this.getTopBlock(block1.getBlockID()));
        String type2 = stackType.get(this.getTopBlock(block2.getBlockID()));
        if ((socket1 == block1.getBeforeConnector() || block1.getBeforeConnector() == null && socket1 == block1.getPlug()) && socket2 == StackRule.getInlineStackSocket(block2)) {
            type2 = block2.getProperty("inline-stack-type");
        } else if ((socket2 == block2.getBeforeConnector() || block2.getBeforeConnector() == null && socket2 == block2.getPlug()) && socket1 == StackRule.getInlineStackSocket(block1)) {
            type1 = block1.getProperty("inline-stack-type");
        }
        return type1 == null || type2 == null || type1.startsWith(type2) || type2.startsWith(type1);
    }

    @Override
    public boolean isMandatory() {
        return true;
    }

    @Override
    public void workspaceEventOccurred(WorkspaceEvent e) {
        BlockLink link = e.getSourceLink();
        if (e.getEventType() == 5) {
            this.makeStack(this.getTopBlock(link.getSocketBlockID()));
        } else if (e.getEventType() == 6) {
            this.makeStack(this.getTopBlock(link.getSocketBlockID()));
            this.makeStack(link.getPlugBlockID());
        }
    }

    private static BlockConnector getInlineStackSocket(Block b) {
        if (b.getProperty("inline-stack-type") == null) {
            return null;
        }
        String inline = b.getProperty("inline-arg");
        if (inline == null) {
            return null;
        }
        return b.getSocketAt(Integer.parseInt(inline));
    }

    private void makeStack(Long blockID) {
        String type = this.getStackType(blockID);
        stackType.put(blockID, type);
    }

    public String getStackType(Long blockID) {
        return this.findStackType(blockID, blockID, "");
    }

    private String findStackType(Long topID, Long startID, String currentType) {
        if (startID == Block.NULL) {
            return "";
        }
        topBlock.put(startID, topID);
        Block b = this.workspace.getEnv().getBlock(startID);
        String type = b.getProperty("stack-type");
        if (type != null && type.length() > currentType.length()) {
            currentType = type;
        }
        BlockConnector inlineSocket = StackRule.getInlineStackSocket(b);
        for (BlockConnector socket : BlockLinkChecker.getSocketEquivalents(b)) {
            if (socket == inlineSocket && socket.hasBlock()) {
                long blockID = socket.getBlockID();
                stackType.put(blockID, this.findStackType(blockID, blockID, b.getProperty("inline-stack-type")));
                continue;
            }
            type = this.findStackType(topID, socket.getBlockID(), currentType);
            if (type.length() <= currentType.length()) continue;
            currentType = type;
        }
        return currentType;
    }

    private Long getTopBlock(Long blockID) {
        if (!topBlock.containsKey(blockID)) {
            this.makeStack(this.findTopBlock(blockID));
        }
        return topBlock.get(blockID);
    }

    private Long findTopBlock(Long blockID) {
        BlockConnector plug = BlockLinkChecker.getPlugEquivalent(this.workspace.getEnv().getBlock(blockID));
        if (plug == null || !plug.hasBlock()) {
            return blockID;
        }
        return this.findTopBlock(plug.getBlockID());
    }
}

