/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblocks.rendering;

import edu.mit.blocks.codeblocks.rendering.ShapeBevel;
import edu.mit.blocks.codeblockutil.GraphicsManager;
import edu.mit.blocks.codeblockutil.LRUCache;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class BlockShapeUtil {
    private static final int BEVEL_CACHE_SIZE = 200;
    private static final LRUCache<BevelCacheKey, BufferedImage> bevelCache = new LRUCache(200);

    public static void lineToRelative(GeneralPath gp, float x, float y) {
        Point2D currentPoint = gp.getCurrentPoint();
        gp.lineTo((float)currentPoint.getX() + x, (float)currentPoint.getY() + y);
    }

    public static void curveTo(GeneralPath gp, float x1, float y1, float x2, float y2, float x3, float y3) {
        Point2D currentPoint = gp.getCurrentPoint();
        gp.curveTo(x1 + (float)currentPoint.getX(), y1 + (float)currentPoint.getY(), x2 + (float)currentPoint.getX(), y2 + (float)currentPoint.getY(), x3 + (float)currentPoint.getX(), y3 + (float)currentPoint.getY());
    }

    public static void cornerTo(GeneralPath gp, Point2D cornerPoint, Point2D nextCornerPoint, float radius) {
        if (radius < 0.001f) {
            gp.lineTo((float)cornerPoint.getX(), (float)cornerPoint.getY());
        } else {
            BlockShapeUtil.makeCornerTo(gp, cornerPoint, nextCornerPoint, radius);
        }
    }

    private static void makeCornerTo(GeneralPath gp, Point2D cornerPoint, Point2D nextCornerPoint, float radius) {
        Point2D currentPoint = gp.getCurrentPoint();
        double distance = currentPoint.distance(cornerPoint);
        double fraction = (distance - (double)radius) / distance;
        double xDistance = (cornerPoint.getX() - currentPoint.getX()) * fraction;
        double yDistance = (cornerPoint.getY() - currentPoint.getY()) * fraction;
        BlockShapeUtil.lineToRelative(gp, (float)xDistance, (float)yDistance);
        Point2D startCurvePoint = gp.getCurrentPoint();
        double distanceFromCornerToNextCorner = cornerPoint.distance(nextCornerPoint);
        double fractionToNextCorner = (double)radius / distanceFromCornerToNextCorner;
        double xDistanceFromCornerToEndCurve = (nextCornerPoint.getX() - cornerPoint.getX()) * fractionToNextCorner;
        double yDistanceFromCornerToEndCurve = (nextCornerPoint.getY() - cornerPoint.getY()) * fractionToNextCorner;
        Point2D.Double endCurvePoint = new Point2D.Double(cornerPoint.getX() + xDistanceFromCornerToEndCurve, cornerPoint.getY() + yDistanceFromCornerToEndCurve);
        BlockShapeUtil.cornerShape(gp, (float)startCurvePoint.getX(), (float)startCurvePoint.getY(), (float)cornerPoint.getX(), (float)cornerPoint.getY(), (float)((Point2D)endCurvePoint).getX(), (float)((Point2D)endCurvePoint).getY());
    }

    public static void cornerShape(GeneralPath gp, float x1, float y1, float x2, float y2, float x3, float y3) {
        gp.curveTo((x1 + x2) / 2.0f, (y1 + y2) / 2.0f, (x2 + x3) / 2.0f, (y2 + y3) / 2.0f, x3, y3);
    }

    public static Image getBevelImage(int width, int height, Area s) {
        BevelCacheKey key = new BevelCacheKey(width, height, s);
        BufferedImage img = bevelCache.get(key);
        if (img != null) {
            return img;
        }
        float[] light = ShapeBevel.getLightVector(-1.0f, -2.0f, 2.0f);
        int bevelSize = 3;
        img = GraphicsManager.gc.createCompatibleImage(width, height, 3);
        Graphics2D g2 = (Graphics2D)img.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(ShapeBevel.getFrontFaceOverlay(light));
        g2.fill(s);
        ShapeBevel.createShapeBevel(g2, s, 0.1, bevelSize, bevelSize, light);
        BevelCacheKey key2 = new BevelCacheKey(width, height, new Area(s));
        bevelCache.put(key2, img);
        return img;
    }

    public static void appendPath(GeneralPath gp1, GeneralPath gp2, boolean reversed) {
        ArrayList<Number[]> points = new ArrayList<Number[]>();
        PathIterator i = gp2.getPathIterator(new AffineTransform());
        float[] segment = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        float leftmost = Float.POSITIVE_INFINITY;
        while (!i.isDone()) {
            int type = i.currentSegment(segment);
            i.next();
            points.add(new Number[]{new Integer(type), new Float(segment[0]), new Float(segment[1]), new Float(segment[2]), new Float(segment[3]), new Float(segment[4]), new Float(segment[5])});
        }
        if (reversed) {
            float deltaX = (float)gp1.getCurrentPoint().getX();
            float deltaY = (float)gp1.getCurrentPoint().getY();
            Object[] typeAndPoints = (Object[])points.get(points.size() - 1);
            int type = (Integer)typeAndPoints[0];
            if (type == 1) {
                deltaX -= ((Float)typeAndPoints[1]).floatValue();
                deltaY -= ((Float)typeAndPoints[2]).floatValue();
            } else if (type == 2) {
                deltaX -= ((Float)typeAndPoints[3]).floatValue();
                deltaY -= ((Float)typeAndPoints[4]).floatValue();
            } else if (type == 3) {
                deltaX -= ((Float)typeAndPoints[5]).floatValue();
                deltaY -= ((Float)typeAndPoints[6]).floatValue();
            } else assert (false) : type;
            int j = points.size() - 1;
            while (j >= 1) {
                typeAndPoints = (Object[])points.get(j);
                type = (Integer)typeAndPoints[0];
                float x1 = ((Float)typeAndPoints[1]).floatValue();
                float y1 = ((Float)typeAndPoints[2]).floatValue();
                float x2 = ((Float)typeAndPoints[3]).floatValue();
                float y2 = ((Float)typeAndPoints[4]).floatValue();
                float prevX = 0.0f;
                float prevY = 0.0f;
                int prevType = (Integer)((Number[])points.get(j - 1))[0];
                if (prevType == 0 || prevType == 1) {
                    prevX = ((Float)((Number[])points.get(j - 1))[1]).floatValue();
                    prevY = ((Float)((Number[])points.get(j - 1))[2]).floatValue();
                } else if (prevType == 2) {
                    prevX = ((Float)((Number[])points.get(j - 1))[3]).floatValue();
                    prevY = ((Float)((Number[])points.get(j - 1))[4]).floatValue();
                } else if (prevType == 3) {
                    prevX = ((Float)((Number[])points.get(j - 1))[5]).floatValue();
                    prevY = ((Float)((Number[])points.get(j - 1))[6]).floatValue();
                } else assert (false) : prevType;
                leftmost = Math.min(leftmost, prevX + deltaX);
                if (type == 0 || type == 1) {
                    gp1.lineTo(prevX + deltaX, prevY + deltaY);
                } else if (type == 2) {
                    gp1.quadTo(x1 + deltaX, y1 + deltaY, prevX + deltaX, prevY + deltaY);
                } else if (type == 3) {
                    gp1.curveTo(x2 + deltaX, y2 + deltaY, x1 + deltaX, y1 + deltaY, prevX + deltaX, prevY + deltaY);
                } else assert (false) : type;
                --j;
            }
        } else {
            float deltaX = (float)gp1.getCurrentPoint().getX() - ((Float)((Number[])points.get(0))[1]).floatValue();
            float deltaY = (float)gp1.getCurrentPoint().getY() - ((Float)((Number[])points.get(0))[2]).floatValue();
            int j = 1;
            while (j < points.size()) {
                Object[] typeAndPoints = (Object[])points.get(j);
                int type = (Integer)typeAndPoints[0];
                float x1 = ((Float)typeAndPoints[1]).floatValue();
                float y1 = ((Float)typeAndPoints[2]).floatValue();
                float x2 = ((Float)typeAndPoints[3]).floatValue();
                float y2 = ((Float)typeAndPoints[4]).floatValue();
                float x3 = ((Float)typeAndPoints[5]).floatValue();
                float y3 = ((Float)typeAndPoints[6]).floatValue();
                if (type != 0) {
                    if (type == 1) {
                        gp1.lineTo(x1 + deltaX, y1 + deltaY);
                        leftmost = Math.min(leftmost, x1 + deltaX);
                    } else if (type == 2) {
                        gp1.quadTo(x1 + deltaX, y1 + deltaY, x2 + deltaX, y2 + deltaY);
                        leftmost = Math.min(leftmost, x2 + deltaX);
                    } else if (type == 3) {
                        gp1.curveTo(x1 + deltaX, y1 + deltaY, x2 + deltaX, y2 + deltaY, x3 + deltaX, y3 + deltaY);
                        leftmost = Math.min(leftmost, x3 + deltaX);
                    } else assert (false) : type;
                }
                ++j;
            }
        }
    }

    public static void printPath(GeneralPath gp) {
        if (gp == null) {
            System.out.println("(null path)");
            return;
        }
        float[] segment = new float[6];
        PathIterator i = gp.getPathIterator(new AffineTransform());
        while (!i.isDone()) {
            int type = i.currentSegment(segment);
            if (type == 0) {
                System.out.println("m: (" + segment[0] + ", " + segment[1] + ")");
            } else if (type == 1) {
                System.out.println("l: (" + segment[0] + ", " + segment[1] + ")");
            } else if (type == 2) {
                System.out.println("q: (" + segment[0] + ", " + segment[1] + "), (" + segment[2] + ", " + segment[3] + ")");
            } else if (type == 3) {
                System.out.println("c: (" + segment[0] + ", " + segment[1] + "), (" + segment[2] + ", " + segment[3] + "), (" + segment[4] + ", " + segment[5] + ")");
            }
            i.next();
        }
    }

    private static class BevelCacheKey {
        public final int width;
        public final int height;
        public final Area area;
        private final int hashCode;

        public BevelCacheKey(int width, int height, Area area) {
            this.width = width;
            this.height = height;
            this.area = area;
            this.hashCode = this.computeHashCode();
        }

        private int computeHashCode() {
            int hash = this.width * 1313 + this.height * 71;
            PathIterator pi = this.area.getPathIterator(null);
            double[] arg = new double[6];
            while (!pi.isDone()) {
                int i = 0;
                while (i < 6) {
                    arg[i] = 0.0;
                    ++i;
                }
                int val = pi.getWindingRule();
                val += 3 * pi.currentSegment(arg);
                int i2 = 0;
                while (i2 < 6) {
                    val = val * 5 + (int)Math.floor(arg[i2] * 1000.0);
                    ++i2;
                }
                hash = hash * 7 + val;
                pi.next();
            }
            return hash;
        }

        public boolean equals(Object o) {
            if (!(o instanceof BevelCacheKey) || o.hashCode() != this.hashCode) {
                return false;
            }
            BevelCacheKey b = (BevelCacheKey)o;
            return this.width == b.width && this.height == b.height && this.area.equals(b.area);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

