/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.workspace;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.codeblocks.BlockGenus;
import edu.mit.blocks.renderable.RenderableBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class WorkspaceEnvironment {
    private final Map<Long, RenderableBlock> allRenderableBlocks = new HashMap<Long, RenderableBlock>();
    private final Map<Long, Block> allBlocks = new HashMap<Long, Block>();
    private long nextBlockID = 1L;
    private final HashMap<String, Long> parentNameToParentBlock = new HashMap();
    private final HashMap<String, ArrayList<Long>> parentNameToBlockStubs = new HashMap();
    private Map<String, BlockGenus> nameToGenus = new HashMap<String, BlockGenus>();

    public RenderableBlock getRenderableBlock(Long blockID) {
        return this.allRenderableBlocks.get(blockID);
    }

    public void addRenderableBlock(RenderableBlock block) {
        this.allRenderableBlocks.put(block.getBlockID(), block);
    }

    public Block getBlock(Long blockID) {
        return this.allBlocks.get(blockID);
    }

    public void addBlock(Block block) {
        long id = block.getBlockID();
        if (this.allBlocks.containsKey(id)) {
            Block dup = this.allBlocks.get(id);
            System.out.println("pre-existing block is: " + dup + " with genus " + dup.getGenusName() + " and label " + dup.getBlockLabel());
            assert (!this.allBlocks.containsKey(id)) : "Block id: " + id + " already exists!  BlockGenus " + block.getGenusName() + " label: " + block.getBlockLabel();
        }
        this.allBlocks.put(id, block);
    }

    public long getNextBlockID() {
        return this.nextBlockID++;
    }

    public void setNextBlockID(long blockID) {
        this.nextBlockID = blockID;
    }

    public Long getParentBlockID(String parentName) {
        return this.parentNameToParentBlock.get(parentName);
    }

    public void putParentBlock(String parentName, Long parentBlockID) {
        this.parentNameToParentBlock.put(parentName, parentBlockID);
    }

    public void removeParentBlock(String parentName) {
        this.parentNameToParentBlock.remove(parentName);
    }

    public boolean containsParentBlock(String parentName) {
        return this.parentNameToParentBlock.containsKey(parentName);
    }

    public ArrayList<Long> getBlockStubs(String parentName) {
        return this.parentNameToBlockStubs.get(parentName);
    }

    public void putBlockStubs(String parentName, ArrayList<Long> blockStubs) {
        this.parentNameToBlockStubs.put(parentName, blockStubs);
    }

    public boolean containsBlockStubs(String parentName) {
        return this.parentNameToBlockStubs.containsKey(parentName);
    }

    public void removeBlockStubs(String parentName) {
        this.parentNameToBlockStubs.remove(parentName);
    }

    public void resetAll() {
        this.allRenderableBlocks.clear();
        this.allBlocks.clear();
        this.nextBlockID = 1L;
        this.parentNameToParentBlock.clear();
        this.parentNameToBlockStubs.clear();
    }

    public BlockGenus getGenusWithName(String name) {
        return this.nameToGenus.get(name);
    }

    public void addBlockGenus(BlockGenus genus) {
        this.nameToGenus.put(genus.getGenusName(), genus);
    }

    public void resetAllGenuses() {
        this.nameToGenus.clear();
    }

    public Iterable<RenderableBlock> getRenderableBlocks() {
        return this.allRenderableBlocks.values();
    }
}

