/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.writer.coretypes;

import java.awt.Color;
import java.io.IOException;
import org.jfree.xml.writer.AbstractXmlWriteHandler;
import org.jfree.xml.writer.AttributeList;
import org.jfree.xml.writer.XMLWriter;
import org.jfree.xml.writer.XMLWriterException;

public class ColorWriteHandler
extends AbstractXmlWriteHandler {
    public void write(String tagName, Object object, XMLWriter writer, String mPlexAttribute, String mPlexValue) throws IOException, XMLWriterException {
        Color color = (Color)object;
        AttributeList attribs = new AttributeList();
        if (mPlexAttribute != null) {
            attribs.setAttribute(mPlexAttribute, mPlexValue);
        }
        attribs.setAttribute("value", this.encodeColor(color));
        if (color.getAlpha() != 255) {
            attribs.setAttribute("alpha", String.valueOf(color.getAlpha()));
        }
        writer.writeTag(tagName, attribs, true);
    }

    private String encodeColor(Color color) {
        return "#" + this.encodeInt(color.getRed()) + this.encodeInt(color.getGreen()) + this.encodeInt(color.getBlue());
    }

    private String encodeInt(int i) {
        String retVal = Integer.toHexString(i);
        if (retVal.length() == 1) {
            return "0" + retVal;
        }
        return retVal;
    }
}

